package ru.yandex.travel.api.services.avia.orders;

import java.util.Map;
import java.util.NoSuchElementException;

import javax.money.CurrencyUnit;
import javax.money.Monetary;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;

import ru.yandex.avia.booking.partners.gateways.aeroflot.AeroflotGateway;
import ru.yandex.avia.booking.partners.gateways.model.booking.BookingFailureReason;
import ru.yandex.avia.booking.service.commons.OrderError;
import ru.yandex.avia.booking.service.commons.OrderState;
import ru.yandex.travel.commons.proto.ECurrency;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.commons.proto.EServiceType;
import ru.yandex.travel.orders.proto.EInvoiceType;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;

class AviaOrchestratorEnumsMapper {
    static final BiMap<CurrencyUnit, ECurrency> CURRENCY_JDK_TO_PROTO =
            ImmutableBiMap.<CurrencyUnit, ECurrency>builder()
            .put(Monetary.getCurrency("RUB"), ECurrency.C_RUB)
            .put(Monetary.getCurrency("USD"), ECurrency.C_USD)
            .build();

    static final Map<EAeroflotOrderState, OrderState> ORDER_STATE_PROTO_TO_API = ImmutableMap.<EAeroflotOrderState,
            OrderState>builder()
            .put(EAeroflotOrderState.OS_NEW, OrderState.NEW)
            .put(EAeroflotOrderState.OS_CHECK_AVAILABILITY, OrderState.BOOKING)
            .put(EAeroflotOrderState.OS_WAIT_CARD_TOKENIZED, OrderState.BOOKED)
            .put(EAeroflotOrderState.OS_WAIT_ORDER_CREATED, OrderState.BOOKED)
            .put(EAeroflotOrderState.OS_WAIT_ORDER_PAID, OrderState.BOOKED)
            .put(EAeroflotOrderState.OS_CONFIRMED, OrderState.TICKETED)
            .put(EAeroflotOrderState.OS_CANCELLED, OrderState.PROCESSING_ERROR)
            .build();
    static final Map<BookingFailureReason, OrderError> SERVICE_ITEM_STATE_TO_ERROR_CODE =
            ImmutableMap.<BookingFailureReason, OrderError>builder()
            .put(BookingFailureReason.NOT_AVAILABLE, OrderError.VARIANTS_NOT_AVAILABLE)
            .put(BookingFailureReason.PRICE_CHANGED, OrderError.PRICE_CHANGED)
            .put(BookingFailureReason.TOKENIZATION_FAILED, OrderError.TOKENIZATION_FAILED)
            .put(BookingFailureReason.PAYMENT_FAILED, OrderError.PAYMENT_FAILED)
            .build();

    static final Map<EAeroflotOrderState, EDisplayOrderState> AEROFLOT_ORDER_TO_EDISPLAY_ORDER_STATE =
            ImmutableMap.<EAeroflotOrderState, EDisplayOrderState>builder()
                    .put(EAeroflotOrderState.OS_NEW, EDisplayOrderState.OS_IN_PROGRESS)
                    .put(EAeroflotOrderState.OS_CHECK_AVAILABILITY, EDisplayOrderState.OS_IN_PROGRESS)
                    .put(EAeroflotOrderState.OS_WAIT_CARD_TOKENIZED, EDisplayOrderState.OS_AWAITS_PAYMENT)
                    .put(EAeroflotOrderState.OS_WAIT_ORDER_CREATED, EDisplayOrderState.OS_AWAITS_PAYMENT)
                    .put(EAeroflotOrderState.OS_WAIT_ORDER_PAID, EDisplayOrderState.OS_AWAITS_PAYMENT)
                    .put(EAeroflotOrderState.OS_CONFIRMED, EDisplayOrderState.OS_FULFILLED)
                    .put(EAeroflotOrderState.OS_CANCELLED, EDisplayOrderState.OS_CANCELLED)
                    .put(EAeroflotOrderState.OS_AUTO_CONFIRMING_INVOICE, EDisplayOrderState.OS_IN_PROGRESS)
                    .put(EAeroflotOrderState.OS_CONFIRMING_ORDER_ITEM, EDisplayOrderState.OS_IN_PROGRESS)
                    .put(EAeroflotOrderState.OS_CANCELLING_ORDER_ITEM, EDisplayOrderState.OS_IN_PROGRESS)
                    .put(EAeroflotOrderState.OS_CANCELLING_INVOICE, EDisplayOrderState.OS_IN_PROGRESS)
                    .put(EAeroflotOrderState.OS_AUTO_RESTORING_INVOICE, EDisplayOrderState.OS_IN_PROGRESS)
                    .put(EAeroflotOrderState.OS_CONFIRMING_ORDER, EDisplayOrderState.OS_IN_PROGRESS)
                    .put(EAeroflotOrderState.OS_EXTERNALLY_CANCELLED, EDisplayOrderState.OS_REFUNDED)
                    .build();


    // the only supported options are aeroflot order / order item at the moment
    static final Map<String, EOrderType> PARTNER_ID_TO_ORDER_TYPE = ImmutableMap.of(
            AeroflotGateway.AEROFLOT_PARTNER_ID, EOrderType.OT_AVIA_AEROFLOT
    );
    static final Map<String, EServiceType> PARTNER_ID_TO_PROVIDER_TYPE = ImmutableMap.of(
            AeroflotGateway.AEROFLOT_PARTNER_ID, EServiceType.PT_FLIGHT
    );
    static final Map<String, EInvoiceType> PARTNER_ID_TO_INVOICE_TYPE = ImmutableMap.of(
            AeroflotGateway.AEROFLOT_PARTNER_ID, EInvoiceType.IT_AVIA_AEROFLOT
    );

    static <K, V> V lookup(Map<K, V> mapping, K key) {
        V value = mapping.get(key);
        if (value == null) {
            throw new NoSuchElementException(String.format("No mapping for the %s key. Mapping: %s", key, mapping));
        }
        return value;
    }

    static <K, V> V lookup(Map<K, V> mapping, K key, V defaultValue) {
        V value = mapping.get(key);
        return value != null ? value : defaultValue;
    }
}
