package ru.yandex.travel.api.services.avia.references;

import org.springframework.stereotype.Service;

@Service
// this place will be extended for new airlines
public class AirlineLoyaltyProgramCodeMapperImpl implements AirlineLoyaltyProgramCodeMapper {
    @Override
    public String getAirlineCodeByInternalCode(String internalCode) {
        return AirlineLoyaltyProgramType.BY_INTERNAL_CODE.getByValue(internalCode).getSuCodeForBooking();
    }

    @Override
    public String getInternalCodeByAirlineCode(String airlineCode) {
        return AirlineLoyaltyProgramType.BY_SU_BOOKING_CODE.getByValueOrNull(airlineCode).getInternalCode();
    }
}
