package ru.yandex.travel.api.services.avia.references;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
@Getter
public enum AirlineLoyaltyProgramType {
    AVIA_SU("avia_su", "SU", "AEROFLOT- AEROFLOT BONUS"),
    AVIA_AR("avia_ar", "AR", "AEROLINEAS ARGENTINAS - AEROLINEAS PLUS"),
    AVIA_AM("avia_am", "AM", "AEROMEXICO - CLUB PREMIER"),
    AVIA_UX("avia_ux", "UX", "AIR EUROPA - SUMA"),
    AVIA_AF("avia_af", "AF", "AIR FRANCE - FLYING BLUE"),
    AVIA_AZ("avia_az", "AZ", "ALITALIA - MILLEMIGLIA"),
    AVIA_CI("avia_ci", "CI", "CHINA AIRLINES - DYNASTY FLYER"),
    AVIA_MU("avia_mu", "MU", "CHINA EASTERN AIRLINES - EASTERN MILES"),
    AVIA_CZ("avia_cz", "CZ", "CHINA SOUTHERN AIRLINES - SKY PEARL CLUB"),
    AVIA_OK("avia_ok", "OK", "CZECH AIRLINES - OK PLUS"),
    AVIA_DL("avia_dl", "DL", "DELTA AIRLINES - SKYMILES"),
    AVIA_GA("avia_ga", "GA", "GARUDA INDONESIA - GARUDA MILES"),
    AVIA_KQ("avia_kq", "KQ", "KENYA AIRWAYS - FLYING BLUE"),
    AVIA_KL("avia_kl", "KL", "KLM - FLYING BLUE"),
    AVIA_KE("avia_ke", "KE", "KOREAN AIR - SKYPASS"),
    AVIA_ME("avia_me", "ME", "MEA - CEDAR MILES"),
    AVIA_AE("avia_ae", "AE", "MANDARIN AIRLINES - DYNASTY FLYER"),
    AVIA_SV("avia_sv", "SV", "SAUDI ARABIAN AIRLINES - ALFURSAN"),
    AVIA_FM("avia_fm", "FM", "SHANGHAI AIRLINES - EASTERN MILES"),
    AVIA_RO("avia_ro", "RO", "TAROM – FLYING BLUE"),
    AVIA_VN("avia_vn", "VN", "VIETNAM AIRLINES - LOTUSMILES"),
    AVIA_MF("avia_mf", "MF", "XIAMEN AIRLINES - EGRET CLUB");

    public static final EnumIndex<String, AirlineLoyaltyProgramType> BY_INTERNAL_CODE = EnumIndex.create(AirlineLoyaltyProgramType.class,
            t -> t.internalCode);
    public static final EnumIndex<String, AirlineLoyaltyProgramType> BY_SU_BOOKING_CODE = EnumIndex.create(AirlineLoyaltyProgramType.class,
            t -> t.suCodeForBooking);

    private final String internalCode;
    private final String suCodeForBooking;
    private final String title;
}
