package ru.yandex.travel.api.services.avia.references;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.avia.booking.partners.gateways.model.search.Flight;
import ru.yandex.travel.api.services.dictionaries.avia.AviaAirportDictionary;
import ru.yandex.travel.api.services.dictionaries.avia.AviaSettlementDictionary;
import ru.yandex.travel.dicts.avia.TAirport;
import ru.yandex.travel.dicts.avia.TSettlement;

@Service
@RequiredArgsConstructor
@Slf4j
public class AviaGeoDataService {
    private final AviaAirportDictionary airportDictionary;
    private final AviaSettlementDictionary settlementDictionary;
    private final AviaGeobaseCountryService geobaseCountryService;

    public AviaFlightGeoData getFlightGeoData(Flight flight) {
        TAirport fromAirport = airportDictionary.getByIataCode(flight.getDepCode());
        TSettlement fromSettlement = settlementDictionary.getById(fromAirport.getSettlementId());
        TAirport toAirport = airportDictionary.getByIataCode(flight.getArrCode());
        TSettlement toSettlement = settlementDictionary.getById(toAirport.getSettlementId());
        return AviaFlightGeoData.builder()
                .fromAirportCode(flight.getDepCode())
                .fromCityCode(fromSettlement.getIataCode())
                .fromCountryCode(geobaseCountryService.getIsoName(fromSettlement.getCountryId()))
                .toAirportCode(flight.getArrCode())
                .toCityCode(toSettlement.getIataCode())
                .toCountryCode(geobaseCountryService.getIsoName(toSettlement.getCountryId()))
                .build();
    }
}
