package ru.yandex.travel.api.services.avia.references;

import java.util.TimeZone;

import com.google.common.base.Strings;

import ru.yandex.avia.booking.service.dto.reference.AirlineReferenceDTO;
import ru.yandex.avia.booking.service.dto.reference.AirportReferenceDTO;
import ru.yandex.avia.booking.service.dto.reference.SettlementReferenceDTO;
import ru.yandex.travel.dicts.avia.TAirline;
import ru.yandex.travel.dicts.avia.TAirport;
import ru.yandex.travel.dicts.avia.TSettlement;

public class AviaReferenceDTOMapper {
    public static AirlineReferenceDTO createAirlineReferenceDTO(TAirline airline) {
        AirlineReferenceDTO airlineReferenceDTO = new AirlineReferenceDTO();
        airlineReferenceDTO.setAlliance(airline.getAlliance());
        airlineReferenceDTO.setColor(airline.getColor());
        airlineReferenceDTO.setId(airline.getId());
        airlineReferenceDTO.setLogoSvg(airline.getLogoSvg());
        airlineReferenceDTO.setTitle(airline.getTitle());
        airlineReferenceDTO.setUrl(airline.getUrl());
        airlineReferenceDTO.setIataCode(airline.getIataCode());
        airlineReferenceDTO.setSirenaCode(airline.getSirenaCode());
        return airlineReferenceDTO;
    }

    public static AirportReferenceDTO createAirportReferenceDTO(TAirport airport) {
        AirportReferenceDTO result = new AirportReferenceDTO();
        result.setCode(airport.getCode());
        result.setId(airport.getId());
        result.setPhraseFrom(airport.getPhraseFrom());
        result.setPhraseIn(airport.getPhraseIn());
        result.setPhraseTo(airport.getPhraseTo());
        result.setSettlement(airport.getSettlementId());
        result.setTitle(airport.getTitle());
        if (!Strings.isNullOrEmpty(airport.getTimeZoneId())) {
            TimeZone tz = TimeZone.getTimeZone(airport.getTimeZoneId());
            result.setTimeZoneCode(tz.getID());
            result.setTimeZoneOffset(tz.getRawOffset() / 1000 / 60);
        }
        return result;
    }

    public static SettlementReferenceDTO createSettlementReferenceDTO(TSettlement settlement) {
        SettlementReferenceDTO result = new SettlementReferenceDTO();
        result.setId(settlement.getId());
        result.setCountryId(settlement.getCountryId());
        result.setPhraseFrom(settlement.getPhraseFrom());
        result.setPhraseIn(settlement.getPhraseIn());
        result.setPhraseTo(settlement.getPhraseTo());
        result.setTitle(settlement.getTitle());
        return result;
    }
}
