package ru.yandex.travel.api.services.avia.td;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;
import lombok.ToString;
import org.javamoney.moneta.Money;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.SearchData.SearchParams;
import ru.yandex.travel.orders.commons.proto.TAviaTestContext;

@Data
@ToString(exclude = "rawData")
public class AviaTdInfo {
    private String variantQid;
    private String variantTag;
    private String partnerCode;
    private JsonNode rawData;
    private Money preliminaryPrice;
    private List<AviaTdSegment> segments;
    private int adultCount;
    private int childrenCount;
    private int infantCount;
    private SearchParams searchParams;
    // should never be null
    private AviaTdPromoCampaigns promoCampaigns;
    private TAviaTestContext testContext;
}
