package ru.yandex.travel.api.services.avia.variants;

import java.time.Duration;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.api.config.avia.AviaBookingConfiguration;

@Component
@ConfigurationProperties(value = "avia-booking", ignoreUnknownFields = false)
@ConditionalOnBean(AviaBookingConfiguration.class)
@Validated
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AviaBookingProperties {
    // this flag actually means "avia order-related services enabled"
    @NotNull
    private Boolean enabled;
    // this flag controls only new orders creation
    @NotNull
    private Boolean newOrdersEnabled;
    @NotEmpty
    private String bookingPageUrl;
    @NotNull
    private Boolean enableTestingScenarios;
    @NotNull
    @Valid
    private VariantCache variantCache;

    private Boolean preferSlaveForStatus;

    private boolean enableOrderStateRefreshing;
    @NotNull
    private Duration refreshStateTimeout;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class VariantCache {
        @NotNull
        private Integer lockAttempts;
        @NotNull
        private Duration lockRetryTimeout;
        @NotNull
        private Duration checkTtl;
        @Positive
        private Integer maxConcurrency;
        @NotNull
        private Duration shutdownTimeout;
    }
}
