package ru.yandex.travel.api.services.avia.variants.model;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.MultiEnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public enum AviaAvailabilityCheckState implements ValueBasedEnum<String> {
    SUCCESS("success"),
    EXTERNAL_REDIRECT("external_redirect"),
    ERROR("error");

    @Getter
    private final String value;

    public static AviaAvailabilityCheckState fromString(String val) {
        return MultiEnumIndex.getGlobal().get(AviaAvailabilityCheckState.class).getByValue(val);
    }
}
