package ru.yandex.travel.api.services.avia.variants.model;

import java.time.LocalDateTime;
import java.util.UUID;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AviaVariantAvailabilityCheck {
    private UUID id;

    private JsonNode data;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private AviaAvailabilityCheckState state;

    public static AviaVariantAvailabilityCheck createForData(JsonNode ticketDaemonData) {
        AviaVariantAvailabilityCheck result = new AviaVariantAvailabilityCheck();
        result.setId(UUID.randomUUID());
        result.setData(ticketDaemonData);
        return result;
    }
}
