package ru.yandex.travel.api.services.buses;

import java.time.Duration;

import org.asynchttpclient.Response;

import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.travel.commons.retry.AhcHttpRetryStrategy;

public class BusesSearchRetryStrategy extends AhcHttpRetryStrategy {

    public BusesSearchRetryStrategy(int numReties) {
        super(Duration.ofSeconds(1), numReties);
    }

    @Override
    public void validateResult(Response result) {
        if (result.getStatusCode() == HttpStatus.SC_202_ACCEPTED) {
            throw new RuntimeException(String.format("Result is not ready, http code is %d", result.getStatusCode()));
        }
    }

    @Override
    public Duration getWaitDuration(int iteration, Exception ex, Response result) {
        Duration waitTime;
        switch (iteration) {
            case 0:
                waitTime = Duration.ofSeconds(1);
                break;
            case 1:
                waitTime = Duration.ofSeconds(2);
                break;
            default:
                waitTime = Duration.ofSeconds(3);
                break;
        }
        return waitTime;
    }
}
