package ru.yandex.travel.api.services.common;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class CountryNameService implements InitializingBean {
    private Map<String, String> countryMap;
    @Override
    public void afterPropertiesSet() throws Exception {
        String mappingJson = Resources.toString(Resources.getResource("country_mapping.json"), Charset.defaultCharset());
        ObjectMapper mapper = new ObjectMapper();
        MapLikeType mapType = mapper.getTypeFactory().constructMapLikeType(HashMap.class, String.class, String.class);
        countryMap = ImmutableMap.copyOf((Map<? extends String, ? extends String>) mapper.readerFor(mapType).readValue(mappingJson));
    }

    public String resolveCountryCode(String code) {
        return countryMap.getOrDefault(code, code);
    }
}
