package ru.yandex.travel.api.services.crosslinks.crosslinks_templates

import org.apache.lucene.document.Document
import org.apache.lucene.document.Field
import org.apache.lucene.document.StringField
import org.apache.lucene.document.StoredField
import org.apache.lucene.index.Term
import org.apache.lucene.search.TermQuery

import ru.yandex.travel.api.proto.crosslinks_template_index.TCrosslinksTemplateItem
import ru.yandex.travel.yt_lucene_index.LuceneIndexBuilder
import ru.yandex.travel.yt_lucene_index.LuceneIndexService
import ru.yandex.travel.yt_lucene_index.utils.DocumentUtils.getProtoField

class CrosslinksTemplateIndexService(
    params: CrosslinksTemplateServiceProperties,
    luceneIndexBuilder: LuceneIndexBuilder<TCrosslinksTemplateItem>
) : LuceneIndexService<TCrosslinksTemplateItem>(params, luceneIndexBuilder, "CrosslinksTemplate"), CrosslinksTemplateDataProvider {
    companion object {
        private const val FIELD_KEY = "key"
        private const val FIELD_PROTO_STORE = "ps"
    }

     override fun getTemplateByKey(key: String): String? {
        val query = TermQuery(Term(FIELD_KEY, key))

        return searchOne(query)?.toCrosslinksTemplateItem()?.template
    }

    private fun Document.toCrosslinksTemplateItem(): TCrosslinksTemplateItem {
        return getProtoField(TCrosslinksTemplateItem.parser(), FIELD_PROTO_STORE)
    }

    override fun documentProducer(row: TCrosslinksTemplateItem): Iterable<Document> {
        val document = Document()

        document.add(StringField(FIELD_KEY, row.key, Field.Store.NO))
        document.add(StoredField(FIELD_PROTO_STORE, row.toByteArray()))

        return listOf(document)
    }
}
