package ru.yandex.travel.api.services.crosslinks.crosslinks_templates;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.proto.crosslinks_template_index.TCrosslinksTemplateItem;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(CrosslinksTemplateServiceProperties.class)
public class CrosslinksTemplateServiceConfiguration {
    @Bean
    public CrosslinksTemplateDataProvider crosslinksTemplateDataProvider(CrosslinksTemplateServiceProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TCrosslinksTemplateItem> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TCrosslinksTemplateItem>()
                    .setProtoClass(TCrosslinksTemplateItem.class);

            return new CrosslinksTemplateIndexService(params, luceneIndexBuilder);
        } else {
            return new DummyCrosslinksTemplateDataProvider();
        }
    }
}
