package ru.yandex.travel.api.services.dictionaries.country;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TCountry;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(CountryDataProviderProperties.class)
public class CountryDataProviderConfiguration {
    @Bean
    public CountryDataProvider countryDataProvider(CountryDataProviderProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TCountry> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TCountry>()
                    .setProtoClass(TCountry.class);

            return new CountryService(params, luceneIndexBuilder);
        } else {
            return new DummyCountryDataProvider();
        }
    }
}
