package ru.yandex.travel.api.services.dictionaries.country

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.health.Health
import org.springframework.boot.actuate.health.HealthIndicator
import org.springframework.stereotype.Component

@Component
@ConditionalOnEnabledHealthIndicator("dict-country")
class CountryDataProviderHealthIndicator(
    private val countryDataProvider: CountryDataProvider
) : HealthIndicator {

    override fun health(): Health {
        return if (countryDataProvider.isReady()) {
            Health.up().build()
        } else {
            Health.down().build()
        }
    }
}
