package ru.yandex.travel.api.services.dictionaries.train.readable_timezone;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TReadableTimezone;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(TrainReadableTimezoneDataProviderProperties.class)
public class TrainReadableTimezoneDataProviderConfiguration {
    @Bean
    public TrainReadableTimezoneDataProvider readableTimezoneDataProvider(TrainReadableTimezoneDataProviderProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TReadableTimezone> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TReadableTimezone>()
                    .setProtoClass(TReadableTimezone.class);

            return new TrainReadableTimezoneService(params, luceneIndexBuilder);
        } else {
            return new DummyTrainReadableTimezoneDataProvider();
        }
    }
}
