package ru.yandex.travel.api.services.dictionaries.train.readable_timezone

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.health.Health
import org.springframework.boot.actuate.health.HealthIndicator
import org.springframework.stereotype.Component

@Component
@ConditionalOnEnabledHealthIndicator("train-readable-timezone")
class TrainReadableTimezoneDataProviderHealthIndicator(
    private val trainReadableTimezoneDataProvider: TrainReadableTimezoneDataProvider
) : HealthIndicator {

    override fun health(): Health {
        return if (trainReadableTimezoneDataProvider.isReady()) {
            Health.up().build()
        } else {
            Health.down().build()
        }
    }
}
