package ru.yandex.travel.api.services.dictionaries.train.readable_timezone

import org.apache.lucene.document.Document
import org.apache.lucene.document.Field
import org.apache.lucene.document.StoredField
import org.apache.lucene.document.StringField
import org.apache.lucene.index.Term
import org.apache.lucene.search.TermQuery
import ru.yandex.travel.dicts.rasp.proto.TReadableTimezone
import ru.yandex.travel.yt_lucene_index.LuceneIndexBuilder
import ru.yandex.travel.yt_lucene_index.LuceneIndexService
import ru.yandex.travel.yt_lucene_index.utils.DocumentUtils.getProtoField

class TrainReadableTimezoneService(
    params: TrainReadableTimezoneDataProviderProperties,
    luceneIndexBuilder: LuceneIndexBuilder<TReadableTimezone>
) : LuceneIndexService<TReadableTimezone>(params, luceneIndexBuilder, "TrainReadableTimezone"), TrainReadableTimezoneDataProvider {

    companion object {
        private val FIELD_KEY_INDEX = "ki"
        private val FIELD_PROTO_STORE = "ps"
    }

    override fun getByKey(key: String): TReadableTimezone {
        val query = TermQuery(Term(FIELD_KEY_INDEX, key))

        return searchOne(query)?.toReadableTimezone()
            ?: throw NoSuchElementException("No such readableTimezone for key: $key")
    }

    override fun documentProducer(row: TReadableTimezone): Iterable<Document> {
        val document = Document()
        val key = "${row.language}/${row.key}"

        document.add(StringField(FIELD_KEY_INDEX, key, Field.Store.NO))
        document.add(StoredField(FIELD_PROTO_STORE, row.toByteArray()))

        return listOf(document)
    }

    private fun Document.toReadableTimezone(): TReadableTimezone {
        return getProtoField(TReadableTimezone.parser(), FIELD_PROTO_STORE)
    }
}
