package ru.yandex.travel.api.services.dictionaries.train.settlement

import ru.yandex.travel.dicts.rasp.proto.TSettlement
import java.util.Optional

interface TrainSettlementDataProvider {
    companion object {
        fun prepareRaspSettlementId(settlementId: Int): String {
            return "c$settlementId"
        }
    }

    fun getById(id: Int): TSettlement

    fun getOptionalSettlementByGeoId(geoId: Int): Optional<TSettlement>

    fun getSettlementCode(settlementId: Int): String?

    fun isReady(): Boolean
}
