package ru.yandex.travel.api.services.dictionaries.train.settlement;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TSettlement;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(TrainSettlementDataProviderProperties.class)
public class TrainSettlementDataProviderConfiguration {

    @Bean
    public TrainSettlementDataProvider settlementDataProvider(TrainSettlementDataProviderProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TSettlement> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TSettlement>()
                    .setProtoClass(TSettlement.class);

            return new TrainSettlementService(params, luceneIndexBuilder);
        } else {
            return new DummyTrainSettlementDataProvider();
        }
    }
}
