package ru.yandex.travel.api.services.dictionaries.train.settlement

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.health.Health
import org.springframework.boot.actuate.health.HealthIndicator
import org.springframework.stereotype.Component

@Component
@ConditionalOnEnabledHealthIndicator("train-settlement")
class TrainSettlementDataProviderHealthIndicator(
    private val trainSettlementDataProvider: TrainSettlementDataProvider
) : HealthIndicator {

    override fun health(): Health {
        return if (trainSettlementDataProvider.isReady()) {
            Health.up().build()
        } else {
            Health.down().build()
        }
    }
}
