package ru.yandex.travel.api.services.dictionaries.train.station;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TStation;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(TrainStationDataProviderProperties.class)
public class TrainStationDataProviderConfiguration {
    @Bean
    public TrainStationDataProvider stationDataProvider(TrainStationDataProviderProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TStation> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TStation>()
                    .setProtoClass(TStation.class);

            return new TrainStationService(params, luceneIndexBuilder);
        } else {
            return new DummyTrainStationDataProvider();
        }
    }
}
