package ru.yandex.travel.api.services.dictionaries.train.station

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.health.Health
import org.springframework.boot.actuate.health.HealthIndicator
import org.springframework.stereotype.Component

@Component
@ConditionalOnEnabledHealthIndicator("train-station")
class TrainStationDataProviderHealthIndicator(
    private val trainStationDataProvider: TrainStationDataProvider
) : HealthIndicator {

    override fun health(): Health {
        return if (trainStationDataProvider.isReady()) {
            Health.up().build()
        } else {
            Health.down().build()
        }
    }
}
