package ru.yandex.travel.api.services.dictionaries.train.station_code

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.health.Health
import org.springframework.boot.actuate.health.HealthIndicator
import org.springframework.stereotype.Component

@Component
@ConditionalOnEnabledHealthIndicator("train-station-code")
class TrainStationCodeDataProviderHealthIndicator(
    private val trainStationCodeDataProvider: TrainStationCodeDataProvider
) : HealthIndicator {

    override fun health(): Health {
        return if (trainStationCodeDataProvider.isReady()) {
            Health.up().build()
        } else {
            Health.down().build()
        }
    }
}
