package ru.yandex.travel.api.services.dictionaries.train.station_express_alias;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TStationExpressAlias;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(TrainStationExpressAliasDataProviderProperties.class)
public class TrainStationExpressAliasDataProviderConfiguration {

    @Bean
    public TrainStationExpressAliasDataProvider stationExpressAliasDataProvider(TrainStationExpressAliasDataProviderProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TStationExpressAlias> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TStationExpressAlias>()
                    .setProtoClass(TStationExpressAlias.class);

            return new TrainStationExpressAliasService(params, luceneIndexBuilder);
        } else {
            return new DummyTrainStationExpressAliasDataProvider();
        }
    }
}
