package ru.yandex.travel.api.services.dictionaries.train.station_express_alias

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.health.Health
import org.springframework.boot.actuate.health.HealthIndicator
import org.springframework.stereotype.Component

@Component
@ConditionalOnEnabledHealthIndicator("train-station-express-alias")
class TrainStationExpressAliasDataProviderHealthIndicator(
    private val trainStationExpressAliasDataProvider: TrainStationExpressAliasDataProvider
) : HealthIndicator {

    override fun health(): Health {
        return if (trainStationExpressAliasDataProvider.isReady()) {
            Health.up().build()
        } else {
            Health.down().build()
        }
    }
}
