package ru.yandex.travel.api.services.dictionaries.train.station_express_alias

import org.apache.lucene.document.Document
import org.apache.lucene.document.Field
import org.apache.lucene.document.IntPoint
import org.apache.lucene.document.StoredField
import org.apache.lucene.document.StringField
import org.apache.lucene.index.Term
import org.apache.lucene.search.TermQuery
import ru.yandex.travel.dicts.rasp.proto.TStationExpressAlias
import ru.yandex.travel.yt_lucene_index.LuceneIndexBuilder
import ru.yandex.travel.yt_lucene_index.LuceneIndexService
import ru.yandex.travel.yt_lucene_index.utils.DocumentUtils.getIntField

class TrainStationExpressAliasService(
    params: TrainStationExpressAliasDataProviderProperties,
    luceneIndexBuilder: LuceneIndexBuilder<TStationExpressAlias>
) : LuceneIndexService<TStationExpressAlias>(params, luceneIndexBuilder, "TrainStationExpressAlias"), TrainStationExpressAliasDataProvider {
    companion object {
        private const val FIELD_STATION_ID_STORE = "sis"
        private const val FIELD_ALIAS = "a"
    }

    override fun getStationIdByExpressName(expressName: String): Int? {
        val query = TermQuery(Term(FIELD_ALIAS, expressName))

        return searchOne(query)?.getIntField(FIELD_STATION_ID_STORE)
    }

    override fun documentProducer(row: TStationExpressAlias): Iterable<Document> {
        val document = Document()

        document.add(StoredField(FIELD_STATION_ID_STORE, row.stationId))
        document.add(StringField(FIELD_ALIAS, row.alias, Field.Store.NO))

        return listOf(document)
    }
}
