package ru.yandex.travel.api.services.dictionaries.train.station_to_settlement;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.dicts.rasp.proto.TStation2Settlement;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(TrainStationToSettlementDataProviderProperties.class)
public class TrainStationToSettlementDataProviderConfiguration {

    @Bean
    public TrainStationToSettlementDataProvider stationToSettlementDataProvider(TrainStationToSettlementDataProviderProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TStation2Settlement> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TStation2Settlement>()
                    .setProtoClass(TStation2Settlement.class);

            return new TrainStationToSettlementService(params, luceneIndexBuilder);
        } else {
            return new DummyTrainStationToSettlementDataProvider();
        }
    }
}
