package ru.yandex.travel.api.services.dictionaries.train.station_to_settlement

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.health.Health
import org.springframework.boot.actuate.health.HealthIndicator
import org.springframework.stereotype.Component

@Component
@ConditionalOnEnabledHealthIndicator("train-station-to-settlement")
class TrainStationToSettlementDataProviderHealthIndicator(
    private val trainStationToSettlementDataProvider: TrainStationToSettlementDataProvider
) : HealthIndicator {

    override fun health(): Health {
        return if (trainStationToSettlementDataProvider.isReady()) {
            Health.up().build()
        } else {
            Health.down().build()
        }
    }
}
