package ru.yandex.travel.api.services.dictionaries.train.time_zone

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.health.Health
import org.springframework.boot.actuate.health.HealthIndicator
import org.springframework.stereotype.Component

@Component
@ConditionalOnEnabledHealthIndicator("train-time-zone")
class TrainTimeZoneDataProviderHealthIndicator(
    private val trainTimeZoneDataProvider: TrainTimeZoneDataProvider
) : HealthIndicator {

    override fun health(): Health {
        return if (trainTimeZoneDataProvider.isReady()) {
            Health.up().build()
        } else {
            Health.down().build()
        }
    }
}
