package ru.yandex.travel.api.services.dictionaries.train.time_zone

import org.apache.lucene.document.Document
import org.apache.lucene.document.IntPoint
import org.apache.lucene.document.StoredField
import ru.yandex.travel.dicts.rasp.proto.TTimeZone
import ru.yandex.travel.yt_lucene_index.LuceneIndexBuilder
import ru.yandex.travel.yt_lucene_index.LuceneIndexService
import ru.yandex.travel.yt_lucene_index.utils.DocumentUtils.getProtoField

class TrainTimeZoneService(
    params: TrainTimeZoneDataProviderProperties,
    luceneIndexBuilder: LuceneIndexBuilder<TTimeZone>
) : LuceneIndexService<TTimeZone>(params, luceneIndexBuilder, "TrainTimeZone"), TrainTimeZoneDataProvider {
    companion object {
        private val FIELD_ID_INDEX = "ii"
        private val FIELD_PROTO_STORE = "ps"
    }

    override fun getById(id: Int): TTimeZone {
        val query = IntPoint.newExactQuery(FIELD_ID_INDEX, id)

        return searchOne(query)?.toTimeZone()
            ?: throw NoSuchElementException("No such timezone for id: $id")
    }

    override fun documentProducer(row: TTimeZone): Iterable<Document> {
        val document = Document()

        document.add(IntPoint(FIELD_ID_INDEX, row.id))
        document.add(StoredField(FIELD_PROTO_STORE, row.toByteArray()))

        return listOf(document)
    }

    private fun Document.toTimeZone(): TTimeZone {
        return getProtoField(TTimeZone.parser(), FIELD_PROTO_STORE)
    }
}
