package ru.yandex.travel.api.services.geo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.geo.model.PointInfo;

import static ru.yandex.travel.api.services.geo.PointInfoHelper.getByIdErrorWrapper;

@Component
@RequiredArgsConstructor
public class PointInfoHierarchyProvider {
    private final PointInfoProviderKernel pointInfoProviderKernel;

    public List<PointInfo> getByPointKey(String pointKey, String locale, String domain) {
        List<PointInfo> result = new ArrayList<>();

        PointInfo pointInfo = getByIdErrorWrapper(pointInfoProviderKernel::getByPointKey, pointKey, locale, domain);
        if (pointInfo != null) {
            result.add(pointInfo);
            result.addAll(getByGeoId(pointInfo.getParentGeoId(), locale, domain));
        }

        return result;
    }

    public List<PointInfo> getByGeoId(Integer pointGeoId, String locale, String domain) {
        if (pointGeoId == null) {
            return Collections.emptyList();
        }
        return pointInfoProviderKernel.getByGeoId(pointGeoId, locale, domain, false);
    }

    public List<PointInfo> getByPointInfo(PointInfo pointInfo, String locale, String domain) {
        if (pointInfo == null) {
            return new ArrayList<>();
        }

        List<PointInfo> result = new ArrayList<>();
        result.add(pointInfo);
        result.addAll(getByGeoId(pointInfo.getParentGeoId(), locale, domain));
        return result;
    }
}
