package ru.yandex.travel.api.services.geo;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.geo.model.PointInfo;

@Component
@RequiredArgsConstructor
public class PointInfoProvider {
    private final PointInfoProviderKernel pointInfoProviderKernel;

    public PointInfo getByPointKey(String pointKey, String locale, String domain) {
        return pointInfoProviderKernel.getByPointKey(pointKey, locale, domain);
    }

    public PointInfo getByGeoId(int pointGeoId, String locale, String domain) {
        List<PointInfo> res = pointInfoProviderKernel.getByGeoId(pointGeoId, locale, domain, true);
        if (res.isEmpty()) {
            return null;
        } else {
            return res.get(0);
        }
    }
}
