package ru.yandex.travel.api.services.geo;

import ru.yandex.travel.api.exceptions.TravelApiBadRequestException;
import ru.yandex.travel.api.services.geo.model.PointId;
import ru.yandex.travel.api.services.geo.model.PointType;

public class PointProviderHelper {
    public static String buildPointKey(char prefix, int pointId) {
        return String.format("%c%s", prefix, pointId);
    }

    public static String buildGeoPointKey(int geoId) {
        return buildPointKey('g', geoId);
    }

    public static String buildStationPointKey(int stationId) {
        return buildPointKey('s', stationId);
    }

    public static String buildSettlementPointKey(int settlementId) {
        return buildPointKey('c', settlementId);
    }

    public static String buildRegionPointKey(int regionId) {
        return buildPointKey('r', regionId);
    }

    public static String buildCountryPointKey(int countryId) {
        return buildPointKey('l', countryId);
    }

    public static PointType getPointType(PointId pointId) {
        switch (pointId.getPointKey().charAt(0)) {
            case 'g':
                return PointType.GEO;
            case 's':
                return PointType.STATION;
            case 'c':
                return PointType.SETTLEMENT;
            case 'r':
                return PointType.REGION;
            case 'l':
                return PointType.COUNTRY;
        }
        return PointType.UNKNOWN;
    }

    public static int parsePointId(String pointKey) {
        try {
            return Integer.parseInt(pointKey.substring(1));
        } catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            throw new TravelApiBadRequestException(String.format("Invalid point key: %s", pointKey));
        }
    }
}
