package ru.yandex.travel.api.services.geo.typed_providers;

import java.util.Collections;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.dictionaries.country.CountryDataProvider;
import ru.yandex.travel.api.services.geo.PointProviderHelper;
import ru.yandex.travel.api.services.geo.model.PointInfo;
import ru.yandex.travel.api.services.geo.model.PointType;
import ru.yandex.travel.api.services.hotels.geobase.GeoBase;
import ru.yandex.travel.dicts.rasp.proto.TCountry;

import static ru.yandex.travel.api.services.geo.typed_providers.TypedPointInfoProviderHelper.getByRawParams;

@Component
@RequiredArgsConstructor
public class CountryPointInfoProvider implements TypedPointInfoProviderInterface {
    private final CountryDataProvider countryDataProvider;
    private final GeoBase geoBase;

    private PointInfo getByCountry(TCountry country, String locale, String domain) {
        int geoId = country.getGeoId();
        return getByRawParams(geoBase, geoId, PointProviderHelper.buildCountryPointKey(geoId), PointType.COUNTRY,
                domain, Collections.emptyList());
    }

    public PointInfo getByGeoId(int geoId, String locale, String domain) {
        TCountry country = countryDataProvider.getByGeoId(geoId);
        return getByCountry(country, locale, domain);
    }

    public PointInfo getById(int id, String locale, String domain) {
        TCountry country = countryDataProvider.getById(id);
        return getByCountry(country, locale, domain);
    }

    public PointInfo getByPointKey(String pointKey, String locale, String domain) {
        return getById(PointProviderHelper.parsePointId(pointKey), locale, domain);
    }
}
