package ru.yandex.travel.api.services.geo.typed_providers;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.models.Region;
import ru.yandex.travel.api.services.geo.PointProviderHelper;
import ru.yandex.travel.api.services.geo.model.PointInfo;
import ru.yandex.travel.api.services.geo.model.PointType;
import ru.yandex.travel.api.services.hotels.geobase.GeoBase;
import ru.yandex.travel.api.services.hotels.geobase.GeoBaseHelpers;
import ru.yandex.travel.api.services.hotels.regions.RegionsService;

import static ru.yandex.travel.api.services.geo.typed_providers.TypedPointInfoProviderHelper.getByRawParams;

@Component
@RequiredArgsConstructor
public class RegionPointInfoProvider implements TypedPointInfoProviderInterface {
    private final RegionsService regionsService;
    private final GeoBase geoBase;

    static private final List<Integer> REGION_PARENT_TYPES = List.of(GeoBaseHelpers.COUNTRY_REGION_TYPE);

    private PointInfo getByInstance(Region region, String locale, String domain) {
        int geoId = region.getGeoId();
        return getByRawParams(geoBase, geoId, PointProviderHelper.buildRegionPointKey(geoId), PointType.REGION,
                domain, REGION_PARENT_TYPES);
    }

    public PointInfo getByGeoId(int geoId, String locale, String domain) {
        Region region = regionsService.getRegion(geoId, locale, domain);
        return getByInstance(region, locale, domain);
    }

    public PointInfo getById(int geoId, String locale, String domain) {
        return getByGeoId(geoId, locale, domain);
    }

    public PointInfo getByPointKey(String pointKey, String locale, String domain) {
        return getById(PointProviderHelper.parsePointId(pointKey), locale, domain);
    }
}
