package ru.yandex.travel.api.services.geo.typed_providers;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.dictionaries.train.settlement.TrainSettlementDataProvider;
import ru.yandex.travel.api.services.geo.PointProviderHelper;
import ru.yandex.travel.api.services.geo.model.PointInfo;
import ru.yandex.travel.api.services.geo.model.PointType;
import ru.yandex.travel.api.services.hotels.geobase.GeoBase;
import ru.yandex.travel.api.services.hotels.geobase.GeoBaseHelpers;
import ru.yandex.travel.dicts.rasp.proto.TSettlement;

import static ru.yandex.travel.api.services.geo.typed_providers.TypedPointInfoProviderHelper.getByRawParams;

@Component
@RequiredArgsConstructor
public class SettlementPointInfoProvider implements TypedPointInfoProviderInterface {
    private final TrainSettlementDataProvider trainSettlementDataProvider;
    private final GeoBase geoBase;

    static private final List<Integer> SETTLEMENT_PARENT_TYPES = List.of(GeoBaseHelpers.REGION_REGION_TYPE, GeoBaseHelpers.COUNTRY_REGION_TYPE);

    public PointInfo getByInstance(TSettlement settlement, String locale, String domain) {
        int geoId = settlement.getGeoId();
        return getByRawParams(geoBase, geoId, PointProviderHelper.buildSettlementPointKey(geoId),
                PointType.SETTLEMENT, domain, SETTLEMENT_PARENT_TYPES);
    }

    @Override
    public PointInfo getByGeoId(int geoId, String locale, String domain) {
        TSettlement settlement = trainSettlementDataProvider.getOptionalSettlementByGeoId(geoId).orElse(null);
        if (settlement == null) {
            return null;
        }
        return getByInstance(settlement, locale, domain);
    }

    @Override
    public PointInfo getById(int id, String locale, String domain) {
        TSettlement settlement = trainSettlementDataProvider.getById(id);
        return getByInstance(settlement, locale, domain);
    }

    public PointInfo getByPointKey(String pointKey, String locale, String domain) {
        return getById(PointProviderHelper.parsePointId(pointKey), locale, domain);
    }
}
