package ru.yandex.travel.api.services.geo.typed_providers;

import java.util.NoSuchElementException;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.models.Linguistics;
import ru.yandex.travel.api.services.dictionaries.train.station.TrainStationDataProvider;
import ru.yandex.travel.api.services.geo.PointProviderHelper;
import ru.yandex.travel.api.services.geo.model.PointInfo;
import ru.yandex.travel.api.services.geo.model.PointType;
import ru.yandex.travel.dicts.rasp.proto.TStation;

@Component
@RequiredArgsConstructor
public class StationPointInfoProvider implements TypedPointInfoProviderInterface {
    private final TrainStationDataProvider stationDataProvider;
    private final SettlementPointInfoProvider settlementPointInfoProvider;

    private PointInfo getByInstance(TStation station, String locale, String domain) {
        int settlementId = station.getSettlementId();
        PointInfo settlementPointInfo = settlementPointInfoProvider.getById(settlementId, locale, domain);
        int settlementGeoId = settlementPointInfo.getGeoId();

        Linguistics linguistics = new Linguistics();
        linguistics.setNominativeCase(station.getTitleRuNominativeCase());
        linguistics.setGenitiveCase(station.getTitleRuGenitiveCase());
        linguistics.setDativeCase("");
        linguistics.setPrepositionalCase(station.getTitleRuPrepositionalCase());
        linguistics.setPreposition(station.getTitleRuPreposition());
        linguistics.setLocativeCase("");
        linguistics.setDirectionalCase("");
        linguistics.setAblativeCase("");
        linguistics.setAccusativeCase(station.getTitleRuAccusativeCase());
        linguistics.setInstrumentalCase("");
        linguistics.setAccusativeCase(station.getTitleRuAccusativeCase());

        return PointInfo.builder()
                .geoId(0)
                .parentGeoId(settlementGeoId)
                .key(PointProviderHelper.buildStationPointKey(station.getId()))
                .type(PointType.STATION)
                .title(station.getTitleRuNominativeCase())
                .slug(station.getSlug())
                .linguistics(linguistics)
                .build();
    }

    public PointInfo getById(int id, String locale, String domain) {
        TStation station = stationDataProvider.getById(id);
        return getByInstance(station, locale, domain);
    }

    public PointInfo getByGeoId(int geoId, String locale, String domain) {
        throw new NoSuchElementException();
    }

    public PointInfo getByPointKey(String pointKey, String locale, String domain) {
        return getById(PointProviderHelper.parsePointId(pointKey), locale, domain);
    }
}
