package ru.yandex.travel.api.services.geo.typed_providers;

import java.util.List;

import ru.yandex.travel.api.models.Linguistics;
import ru.yandex.travel.api.services.geo.model.PointInfo;
import ru.yandex.travel.api.services.geo.model.PointType;
import ru.yandex.travel.api.services.hotels.geobase.GeoBase;
import ru.yandex.travel.api.services.hotels.geobase.GeoBaseHelpers;


class TypedPointInfoProviderHelper {
    public static PointInfo getByRawParams(GeoBase geoBase, int pointGeoId, String pointKey, PointType pointType,
                                           String domain, List<Integer> roundToTypes) {
        var builder = PointInfo
                .builder()
                .geoId(pointGeoId)
                .key(pointKey)
                .type(pointType);

        if (pointGeoId != 0) {
            Linguistics linguistics = GeoBaseHelpers.getRegionLinguistics(geoBase, pointGeoId, domain);
            builder = builder.title(linguistics.getNominativeCase()).linguistics(linguistics);
        }

        for (Integer roundToType : roundToTypes) {
            var parentGeoId = GeoBaseHelpers.getRegionRoundTo(geoBase, pointGeoId, roundToType, domain);
            if (parentGeoId != null) {
                builder.parentGeoId(parentGeoId);
                break;
            }
        }

        return builder.build();
    }
}
