package ru.yandex.travel.api.services.hotels.amenities;

import java.util.ArrayList;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;


@Data
@ConfigurationProperties(value = "hotel-amenities", ignoreUnknownFields = false)
@Validated
public class AmenityServiceProperties {
    @Data
    public static class StaticGeoFeatureConfig {
        @NotEmpty
        private String businessFeatureId;

        @NotEmpty
        private List<String> businessFeatureValues;

        @NotEmpty
        private String name;
    }

    @Data
    public static class DynamicGeoFeatureConfig {
        @NotEmpty
        private String businessFeatureId;

        @NotNull
        private Integer maxValue;

        @NotEmpty
        private String nameSuffix;
    }

    @Data
    public static class GeoFeatureConfig {
        @NotEmpty
        private String id;

        @NotNull
        private Integer importance;

        @NotEmpty
        private String icon;

        private StaticGeoFeatureConfig staticConfig;

        private DynamicGeoFeatureConfig dynamicConfig;

        boolean isSingleConfigDefined() {
            return (staticConfig == null && dynamicConfig != null) || (staticConfig != null && dynamicConfig == null);
        }

        public String getBusinessFeatureId() {
            if (staticConfig != null) {
                return staticConfig.getBusinessFeatureId();
            }
            if (dynamicConfig != null) {
                return dynamicConfig.getBusinessFeatureId();
            }
            return null;
        }
    }

    private List<String> bannedFeatures = new ArrayList<>();
    private List<String> mainFeatureOrder = new ArrayList<>();
    private List<String> featureGroupOrder = new ArrayList<>();

    @Valid
    private List<GeoFeatureConfig> geoFeatures = new ArrayList<>();
}
