package ru.yandex.travel.api.services.hotels.calendar_prices

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import org.springframework.validation.annotation.Validated
import ru.yandex.misc.concurrent.RpsLimiter
import ru.yandex.travel.api.endpoints.hotels_portal.HotelsPortalProperties.PollingDelays
import ru.yandex.travel.hotels.proto.EPartnerId
import java.time.Duration
import javax.validation.Valid
import javax.validation.constraints.Max
import javax.validation.constraints.Min
import javax.validation.constraints.NotEmpty
import javax.validation.constraints.NotNull
import javax.validation.constraints.Positive

@ConstructorBinding
@Validated
@ConfigurationProperties(value = "hotels-calendar-prices", ignoreUnknownFields = false)
open class CalendarPricesProperties(
    @field:NotNull
    open val offercacheResponseTimeout: Duration = Duration.ofMillis(700),
    @field:NotNull
    @field:Min(1)
    @field:Max(120)
    open val daysPerSingleRequestLimit: Int = 100,
    @field:NotNull
    @field:Valid
    open val pollingDelays: PollingDelays = PollingDelays(),
    @field:NotNull
    @field:Valid
    open val throttlerProperties: ThrottlerProperties,
)

@ConstructorBinding
@Validated
open class ThrottlerProperties(
    @field:NotNull
    open val rateLimit: Long,
    @field:NotNull
    open val semaphoreLimit: Long,
    @field:NotNull
    open val bucket: Duration,
    @field:NotNull
    open val window: Duration
)
