package ru.yandex.travel.api.services.hotels.calendar_prices

import ru.yandex.travel.api.endpoints.hotels_portal.HotelsPortalUtils
import ru.yandex.travel.api.proto.hotels_portal.TCalendarPricesSearchContext
import ru.yandex.travel.api.proto.hotels_portal.TCalendarPricesSearchContextOrBuilder

data class CalendarPricesSearchContext(
    private val proto: TCalendarPricesSearchContext.Builder = TCalendarPricesSearchContext.newBuilder(),
) : TCalendarPricesSearchContextOrBuilder by proto {

    fun incrementPollingIteration() {
        proto.pollingIteration = proto.pollingIteration + 1
    }

    fun serialize(): String {
        return HotelsPortalUtils.encodeProtoToString(proto.build())
    }

    companion object {
        fun deserialize(context: String?): CalendarPricesSearchContext {
            if (context == null) {
                return CalendarPricesSearchContext()
            }
            return CalendarPricesSearchContext(
                TCalendarPricesSearchContext.parseFrom(
                    HotelsPortalUtils.decodeBytesFromString(
                        context
                    )
                ).toBuilder()
            )
        }
    }
}
