package ru.yandex.travel.api.services.hotels.geobase;

import java.util.List;

import ru.yandex.geobase6.Hash;
import ru.yandex.geobase6.LinguisticsItem;
import ru.yandex.geobase6.RegionHash;
import ru.yandex.geobase6.Reliability;
import ru.yandex.geobase6.Timezone;

public interface GeoBase {
    default RegionHash getRegionByIp(String ip) {
        return getRegionByIp(ip, "");
    }
    RegionHash getRegionByIp(String ip, String domain);

    default RegionHash getRegionById(int id) {
        return getRegionById(id, "");
    }
    RegionHash getRegionById(int id, String domain);

    Reliability[] getReliabilitiesByIp(String ip);

    int getRegionIdByIp(String ip);

    long getIspCodeByIp(String ip);

    Hash getIpTraits(String ip);

    int getRegionIdByLocation(double latitude, double longitude);

    default int getParentId(int id) {
        return getParentId(id, "");
    }
    int getParentId(int id, String domain);

    default int getCountryId(int region_id) {
        return getCountryId(region_id, "");
    }
    int getCountryId(int region_id, String domain);

    default List<RegionHash> getRegionsPath(int id) {
        return getRegionsPath(id, "");
    }
    List<RegionHash> getRegionsPath(int id, String domain);

    default boolean isIpInRegion(String ip, int parentId) {
        return isIpInRegion(ip, parentId, "");
    }
    boolean isIpInRegion(String ip, int parentId, String domain);

    default boolean isIdInRegion(int regionId, int parentId) {
        return isIdInRegion(regionId, parentId, "");
    }
    boolean isIdInRegion(int regionId, int parentId, String domain);

    default int[] getChildrenIds(int id) {
        return getChildrenIds(id, "");
    }
    int[] getChildrenIds(int id, String domain);

    default int[] getParentsIds(int id) {
        return getParentsIds(id, "");
    }
    int[] getParentsIds(int id, String domain);

    default int[] getRegionsIdsByType(int type) {
        return getRegionsIdsByType(type, "");
    }
    int[] getRegionsIdsByType(int type, String domain);

    String getAsNameByIp(String ip);

    boolean isTorIp(String ip);

    String getTimezoneName(int id);

    Timezone getTimezoneById(int id);

    Timezone getTimezoneByName(String tzname);

    Timezone getTimezoneByLocation(double lat, double lon);

    Timezone getTimezoneByLongitude(double lon);

    LinguisticsItem getLinguistics(int regionId, String language);

    String[] getSupportedLinguistics();
}
