package ru.yandex.travel.api.services.hotels.geobase;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.geobase6.Hash;
import ru.yandex.geobase6.LinguisticsItem;
import ru.yandex.geobase6.Lookup;
import ru.yandex.geobase6.RegionHash;
import ru.yandex.geobase6.Reliability;
import ru.yandex.geobase6.Timezone;

@Slf4j
public class LookupGeoBase implements GeoBase, Closeable {
    private final Lookup lookup;

    public LookupGeoBase(boolean isEnabled, String filename) {
        if (isEnabled) {
            lookup = new Lookup(filename);
        } else {
            log.warn("GeoBase is not enabled");
            lookup = null;
        }
    }

    private Lookup getImpl() {
        if (lookup == null) {
            throw new RuntimeException("Geobase is disabled in config");
        }
        return lookup;
    }

    @Override
    public RegionHash getRegionByIp(String ip, String domain) {
        return getImpl().getRegionByIp(ip, domain);
    }

    @Override
    public RegionHash getRegionById(int id, String domain) {
        return getImpl().getRegionById(id, domain);
    }

    @Override
    public Reliability[] getReliabilitiesByIp(String ip) {
        return getImpl().getReliabilitiesByIp(ip);
    }

    @Override
    public int getRegionIdByIp(String ip) {
        return (int) getImpl().getRegionIdByIp(ip);
    }

    @Override
    public long getIspCodeByIp(String ip) {
        return getImpl().getIspCodeByIp(ip);
    }

    @Override
    public Hash getIpTraits(String ip) {
        return getImpl().getIpTraits(ip);
    }

    @Override
    public int getRegionIdByLocation(double latitude, double longitude) {
        return (int) getImpl().getRegionIdByLocation(latitude, longitude);
    }

    @Override
    public int getParentId(int id, String domain) {
        return getImpl().getParentId(id, domain);
    }

    @Override
    public int getCountryId(int region_id, String domain) {
        return getImpl().getCountryId(region_id, domain);
    }

    @Override
    public List<RegionHash> getRegionsPath(int id, String domain) {
        return getImpl().getRegionsPath(id, domain);
    }

    @Override
    public boolean isIpInRegion(String ip, int parentId, String domain) {
        return getImpl().isIpInRegion(ip, parentId, domain);
    }

    @Override
    public boolean isIdInRegion(int regionId, int parentId, String domain) {
        return getImpl().isIdInRegion(regionId, parentId, domain);
    }

    @Override
    public int[] getChildrenIds(int id, String domain) {
        return getImpl().getChildrenIds(id, domain);
    }

    @Override
    public int[] getParentsIds(int id, String domain) {
        return getImpl().getParentsIds(id, domain);
    }

    @Override
    public int[] getRegionsIdsByType(int type, String domain) {
        return getImpl().getRegionsIdsByType(type, domain);
    }

    @Override
    public String getAsNameByIp(String ip) {
        return getImpl().getAsNameByIp(ip);
    }

    @Override
    public boolean isTorIp(String ip) {
        return getImpl().isTorIp(ip);
    }

    @Override
    public String getTimezoneName(int id) {
        return getImpl().getTimezoneName(id);
    }

    @Override
    public Timezone getTimezoneById(int id) {
        return getImpl().getTimezoneById(id);
    }

    @Override
    public Timezone getTimezoneByName(String tzname) {
        return getImpl().getTimezoneByName(tzname);
    }

    @Override
    public Timezone getTimezoneByLocation(double lat, double lon) {
        return getImpl().getTimezoneByLocation(lat, lon);
    }

    @Override
    public Timezone getTimezoneByLongitude(double lon) {
        return getImpl().getTimezoneByLongitude(lon);
    }

    @Override
    public LinguisticsItem getLinguistics(int regionId, String language) {
        return getImpl().getLinguistics(regionId, language);
    }

    @Override
    public String[] getSupportedLinguistics() {
        return getImpl().getSupportedLinguistics();
    }

    @Override
    public void close() throws IOException {
        if (lookup != null) {
            lookup.close();
        }
    }
}
