package ru.yandex.travel.api.services.hotels.geocounter;

import java.time.Duration;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.orders.client.FailureDetectorProperties;
import ru.yandex.travel.orders.client.GrpcChannelSupplierMode;
import ru.yandex.travel.orders.client.GrpcChannelSupplierProperties;
import ru.yandex.travel.orders.client.yp.YpDiscoveryProperties;

@Data
@Validated
@ConfigurationProperties(value = "geo-counter", ignoreUnknownFields = false)
public class GeoCounterProperties {

    @Data
    public static class GeoCounterChannelProperties implements GrpcChannelSupplierProperties {

        private List<String> targets;

        @Valid
        private YpDiscoveryProperties yp;

        @Valid
        @NotNull
        private GrpcChannelSupplierMode mode;
    }

    @Valid
    @NotNull
    private GeoCounterChannelProperties channel;

    @Valid
    private GeoCounterChannelProperties prodChannel; // Только для тестинга, адрес продового GeoCounter-а

    @Valid
    private FailureDetectorProperties failureDetection;

    @NotNull
    private Duration timeout;

    @Positive
    private int maxMessageSize;
}
