package ru.yandex.travel.api.services.hotels.geocounter.model;

import java.time.Duration;
import java.time.LocalDate;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.hotels.BoundingBox;
import ru.yandex.travel.api.models.hotels.Coordinates;
import ru.yandex.travel.hotels.common.Ages;
import ru.yandex.travel.hotels.proto.geocounter_service.ESortType;
import ru.yandex.travel.hotels.proto.geocounter_service.TGetHotelsResponse;

@Data
@NoArgsConstructor
public class GeoCounterGetHotelsRsp {
    @Data
    @AllArgsConstructor
    public static class HotelResultCounts {
        private int hotelsOnCurrentPageCount;
        private boolean haveMoreHotels;
        private int totalHotelsCount;
    }

    private List<TGetHotelsResponse.THotel> hotels;
    private HotelResultCounts hotelResultCounts;
    private boolean pollingFinished;
    private String pollingContext;
    private String pollingId;
    private int geoId;
    private BoundingBox bbox;
    private LocalDate checkInDate;
    private LocalDate checkOutDate;
    private Ages ages;
    private ESortType sortType;
    private Coordinates sortOrigin;
    private Duration responseTime;
    private boolean hotelLocationUseful;
    private Boolean hasBoyOffers;
    private String reqId;
    private String sessionId;
    private boolean cryptaDataAvailable;
    private TGetHotelsResponse.THotels.TLogData logData;
}
