package ru.yandex.travel.api.services.hotels.geocounter.model;

import java.time.LocalDate;
import java.util.List;

import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.hotels.BoundingBox;
import ru.yandex.travel.api.models.hotels.HotelAdditionalFilter;
import ru.yandex.travel.api.models.hotels.HotelFilterGroup;

@Data
@NoArgsConstructor
public class GeoCounterReq {
    private LocalDate checkinDate;
    private LocalDate checkoutDate;
    private String ages;
    private BoundingBox bbox;
    private Integer filterPriceFrom;
    private Integer filterPriceTo;
    private String nameSuffix;
    private List<HotelFilterGroup> initialFilterGroups;
    private List<HotelAdditionalFilter> additionalFilters;
    private boolean useOfferBus;
    private boolean useProdGeoCounter = false;
}
