package ru.yandex.travel.api.services.hotels.hotel_images

import org.apache.lucene.document.Document
import org.apache.lucene.document.LongPoint
import org.apache.lucene.document.StoredField
import ru.yandex.travel.api.proto.hotels_index.TImageWhitelistItem;
import ru.yandex.travel.hotels.common.Permalink
import ru.yandex.travel.yt_lucene_index.LuceneIndexBuilder
import ru.yandex.travel.yt_lucene_index.LuceneIndexService
import ru.yandex.travel.yt_lucene_index.utils.DocumentUtils.getProtoField
import kotlin.streams.toList

class ImageWhitelistService(
    params: ImageWhitelistServiceProperties,
    luceneIndexBuilder: LuceneIndexBuilder<TImageWhitelistItem>
) : LuceneIndexService<TImageWhitelistItem>(params, luceneIndexBuilder, "ImageWhitelist"), ImageWhitelistDataProvider {
    companion object {
        private const val FIELD_PERMALINK_INDEX = "pi"
        private const val FIELD_PROTO_STORE = "ps"
    }

    override fun getPermalinkImages(permalink: Permalink): List<String>? {
        val query = LongPoint.newExactQuery(FIELD_PERMALINK_INDEX, permalink.asLong())

        return searchOne(query)?.toImages()
    }

    private fun Document.toImages(): List<String> {
        return getProtoField(TImageWhitelistItem.parser(), FIELD_PROTO_STORE)
            .photoUrlsList
            .stream()
            .toList()
    }

    override fun documentProducer(row: TImageWhitelistItem): Iterable<Document> {
        val document = Document()

        document.add(LongPoint(FIELD_PERMALINK_INDEX, row.permalink))
        document.add(StoredField(FIELD_PROTO_STORE, row.toByteArray()))

        return listOf(document)
    }
}
