package ru.yandex.travel.api.services.hotels.hotel_images;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.proto.hotels_index.TImageWhitelistItem;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(ImageWhitelistServiceProperties.class)
public class ImageWhitelistServiceConfiguration {
    @Bean
    public ImageWhitelistDataProvider imageWhitelistDataProvider(ImageWhitelistServiceProperties params) {
        if (params.isEnabled()) {
            ProtobufYtLuceneIndexBuilder<TImageWhitelistItem> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<TImageWhitelistItem>()
                    .setProtoClass(TImageWhitelistItem.class);

            return new ImageWhitelistService(params, luceneIndexBuilder);
        } else {
            return new DummyImageWhitelistDataProvider();
        }
    }
}
