package ru.yandex.travel.api.services.hotels.legacy;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;


@ConditionalOnProperty(value = "hotels.legacy.index.type", havingValue = "none")
@Component
@Slf4j
public class LegacyHotelInfoEmptyProvider implements LegacyHotelInfoProvider, InitializingBean {

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public LegacyHotelInfo getHotelInfo(long hotelId) {
        return null;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.warn("The loading of hotel index is disabled, will find no legacy hotels");
    }
}
